#include "interrupt_form.h"
#include "ui_interrupt_form.h"

i32 counter = 0;

// ------------ constructor & destructor ---------------
Interrupt_Form::Interrupt_Form(QWidget *parent, Qt::WindowFlags fl ):
    QWidget(parent, fl),
    ui(new Ui::Interrupt_Form)
{
    ui->setupUi(this);
    this->timer_started = false;    
    int index = 0;

    QCheckBox *temp_Bit_checkBox[] = { this->ui->Port0Bit0_checkBox, this->ui->Port0Bit1_checkBox, this->ui->Port0Bit2_checkBox,
                                       this->ui->Port0Bit3_checkBox, this->ui->Port0Bit4_checkBox, this->ui->Port0Bit5_checkBox,
                                       this->ui->Port0Bit6_checkBox, this->ui->Port0Bit7_checkBox,
                                       this->ui->Tc0IrqMask_checkBox, this->ui->Tc1IrqMask_checkBox };
    QCheckBox *temp_State_checkBox[] = { this->ui->State0_checkBox, this->ui->State1_checkBox, this->ui->State2_checkBox,
                                         this->ui->State3_checkBox, this->ui->State4_checkBox, this->ui->State5_checkBox,
                                         this->ui->State6_checkBox, this->ui->State7_checkBox, this->ui->State8_checkBox, this->ui->State9_checkBox };

    for( index = 0; index < MAX_AD_NUM+2 ; index++ )
      {
        this->Bit_checkBox[ index ] = temp_Bit_checkBox[ index ];
        this->State_checkBox[ index ] = temp_State_checkBox[ index ];
      }

}

Interrupt_Form::~Interrupt_Form()
{
    qWarning("delete Interrupt form");
    delete ui;
}


// ------------ event ---------------
void Interrupt_Form::showEvent(QShowEvent *)
{
    qWarning("showEvent");
    u8 polarity_data = 0;

    if ( false == this->timer_started )
    {
        this->interrupt_timer = startTimer(100);         
        this->timer_started = true;
        this->mask_read();
        this->status_read();

        Status = EX94421A_IRQ_IO_polarity_read( CardID, &polarity_data );
        if ( ACTIVE == polarity_data )
        {
            this->ui->TtlIrqPolarity_checkBox->setChecked(true);
        }
        else
        {
            this->ui->TtlIrqPolarity_checkBox->setChecked(false);
        }
    }
}

void Interrupt_Form::timerEvent ( QTimerEvent *event )
{
    // qWarning("timer");
    if ( event->timerId() == this->interrupt_timer )
    {
        this->status_read();
        this->ui->IrqCounter_label->setText("IRQ Counter: "+ QString::number(counter,10) );
    }
}
void Interrupt_Form::closeEvent ( QCloseEvent *event )
{
    // qWarning("closeEvent");
    killTimer( this->interrupt_timer );
    this->timer_started = false;

    event->accept();
}




// ------------ sub-function ---------------
void Interrupt_Form::mask_read()
{
    qWarning("mask_read");
    u8 index = 0;
    u16 state = 0;

    Status = EX94421A_IRQ_mask_read( CardID, &state);
    for ( index = 0; index < MAX_PORT_NUM+2; index++ )
    {
        if ( ACTIVE == ((state >> index) & 1) )
        {
            this->Bit_checkBox[index]->setChecked(true);
        }
        else
        {
            this->Bit_checkBox[index]->setChecked(false);
        }
    }
}

void Interrupt_Form::status_read()
{
//    qWarning("status_read");
    u8 index = 0;
    u16 state = 0;

    Status = EX94421A_IRQ_status_read(CardID, &state);
    for ( index = 0; index < MAX_PORT_NUM+2; index++ )
    {
        if ( ACTIVE == ((state >> index) & 1) )
        {
            this->State_checkBox[index]->setChecked(true);
        }
        else
        {
            this->State_checkBox[index]->setChecked(false);
        }
    }
}

void callback(u8 Card_ID)
{
    qWarning("test_irq_process %d", Card_ID);
    counter++;
}





// ------------ slot ---------------
void Interrupt_Form::on_IrqEnable_checkBox_clicked(bool checked)
{
//    qWarning("on_IrqEnable_checkBox_clicked");
    if ( true == checked )
    {
        // qWarning("checked");
        Status = EX94421A_IRQ_process_link( CardID, &callback );
        Status = EX94421A_IRQ_enable( CardID );
    }
    else
    {
        // qWarning("non checked");
        Status = EX94421A_IRQ_disable( CardID );
    }
}

void Interrupt_Form::on_Apply_pushButton_clicked()
{
    // set IRQ mask
    int index = 0;
    u16 state = 0;
    u16 temp_state = 0;

    for ( index = 0; index < MAX_PORT_NUM+2; index++ )
    {
        if ( true == this->Bit_checkBox[index]->isChecked() )
        {
            // qWarning("checked");
            temp_state = 1 << index;
            state += temp_state;
        }
    }
    Status = EX94421A_IRQ_mask_set(CardID, state);
}

void Interrupt_Form::on_TtlIrqPolarity_checkBox_clicked(bool checked)
{
    // qWarning("on_IrqEnable_checkBox_clicked");
    if ( true == checked )
    {
        // qWarning("checked");
        Status = EX94421A_IRQ_IO_polarity_set( CardID, ACTIVE );
    }
    else
    {
        // qWarning("non checked");
        Status = EX94421A_IRQ_IO_polarity_set( CardID, INACTIVE );
    }
}
